(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     74095,       1405]
NotebookOptionsPosition[     72830,       1377]
NotebookOutlinePosition[     73233,       1393]
CellTagsIndexPosition[     73190,       1390]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fC", "[", "x_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "x", " ", "+", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"5", "*", "x"}], "]"}]}], ")"}], "/", "2"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"5", "*", "x"}], "]"}]}], ")"}], "/", "2"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"fD", "[", "x_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Cos", "[", 
         RowBox[{"5", "*", "x"}], "]"}]}], ")"}], "/", "2"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "x", "+", 
        RowBox[{"Cos", "[", 
         RowBox[{"3", "*", "x"}], "]"}]}], ")"}], "/", "2"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ag1", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"fC", "[", "x", "]"}], "+", 
      RowBox[{"fD", "[", "x", "]"}]}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ag2", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"fD", "[", "x", "]"}], "+", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0.05", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"10", "*", "x"}], "]"}]}], ",", 
      RowBox[{"0.05", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"10", "*", "x"}], "+", "1"}], "]"}]}], ",", 
      RowBox[{"0.05", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"10", "*", "x"}], "+", "2"}], "]"}]}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"fC", "[", "t", "]"}], ",", 
       RowBox[{"fD", "[", "t", "]"}], ",", " ", 
       RowBox[{"ag1", "[", "t", "]"}], ",", 
       RowBox[{"ag2", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", " ", 
     RowBox[{"PlotLabels", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Subscript", "[", 
         RowBox[{"f", ",", "C"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{"f", ",", "D"}], "]"}], ",", 
        RowBox[{"Subscript", "[", 
         RowBox[{"f", ",", "1"}], "]"}], ",", " ", 
        RowBox[{"Subscript", "[", 
         RowBox[{"f", ",", "2"}], "]"}], ",", 
        RowBox[{"FontSize", "->", "18"}]}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"x", ",", 
          RowBox[{"FontSize", "->", "18"}]}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"Subscript", "[", 
           RowBox[{"y", ",", "1"}], "]"}], ",", 
          RowBox[{"FontSize", "->", "18"}]}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"Subscript", "[", 
           RowBox[{"y", ",", "2"}], "]"}], ",", 
          RowBox[{"FontSize", "->", "18"}]}], "]"}]}], "}"}]}], ",", 
     RowBox[{"AxesOrigin", "->", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"Boxed", "->", "False"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.55", ",", 
         RowBox[{
          RowBox[{"ag1", "[", "0.55", "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"ag1", "[", "0.55", "]"}], "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.55", ",", 
         RowBox[{
          RowBox[{"fC", "[", "0.55", "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"fC", "[", "0.55", "]"}], "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "}"}], "]"}], "]"}], ",",
    "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.55", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"VertexColors", "\[Rule]", 
         RowBox[{"{", "Red", "}"}]}]}], "]"}]}], "}"}], "]"}]}], 
  "\[IndentingNewLine]", "]"}]}], "Input",
 CellChangeTimes->{{3.8732826049093943`*^9, 3.873282689763329*^9}, {
   3.873282730788259*^9, 3.873282880034005*^9}, {3.873284244409408*^9, 
   3.873284283755014*^9}, {3.873284358353835*^9, 3.87328437213992*^9}, {
   3.8732844145685177`*^9, 3.873284453639793*^9}, {3.873284679269487*^9, 
   3.8732847530299892`*^9}, {3.873284799899723*^9, 3.8732848059088907`*^9}, {
   3.873284907825254*^9, 3.873285038955744*^9}, {3.873285495391489*^9, 
   3.873285551364415*^9}, {3.8732856918468523`*^9, 3.8732857336021843`*^9}, {
   3.873286076871127*^9, 3.873286080045081*^9}, {3.873300763644765*^9, 
   3.873300871645441*^9}, {3.873302157456798*^9, 3.873302244719911*^9}, {
   3.873302284434417*^9, 3.873302290680389*^9}, {3.873302374300139*^9, 
   3.8733023786168613`*^9}, {3.873302520933157*^9, 3.8733025219511147`*^9}, {
   3.873302689643346*^9, 3.873302733048724*^9}, {3.873302799386438*^9, 
   3.8733028226632767`*^9}, {3.873302876252104*^9, 3.8733030342222548`*^9}, {
   3.873303069143598*^9, 3.873303094748206*^9}, {3.873303141172874*^9, 
   3.873303301870243*^9}, {3.873303366344831*^9, 3.87330341946741*^9}, 
   3.873303452259968*^9, {3.873304425652328*^9, 3.8733044406754923`*^9}, {
   3.8733044856385717`*^9, 3.873304514277307*^9}, {3.873304587489049*^9, 
   3.873304599072728*^9}, {3.873305053183077*^9, 3.8733050681320677`*^9}, {
   3.8733052514474916`*^9, 3.8733052767957153`*^9}, {3.873305322042976*^9, 
   3.873305322315078*^9}, {3.873305435718815*^9, 3.8733055899354563`*^9}, {
   3.87337284795912*^9, 3.873372862165473*^9}, {3.8733729076279078`*^9, 
   3.8733729359051943`*^9}, {3.873373022155389*^9, 3.87337302323632*^9}, {
   3.873375330202373*^9, 3.873375379228853*^9}, {3.873375560549988*^9, 
   3.873375565833624*^9}, {3.873375632678217*^9, 3.873375635898407*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"1d8ad072-048c-480a-a5ce-a5ffbc448f59"],

Cell[BoxData[
 Graphics3DBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
       Line3DBox[CompressedData["
1:eJwd2Hk4lF8bB3ASZfmRFqVSpLQnoaSaL1FK2ixtWmRPilSKKIQoW0j2tFCW
RBSlJCllyTJjBlnGknVmHqZsFd4z719zXZ/rXOe55z73uZ9zHiVLJ2ObKUJC
QkuEhYREyK+hTU9NUa8ZTfthi6KQEBtiatYLBL9T9eY7t8pr4OrbpJzAaWww
8lPn7BJjQ/1BdHyOvD66Jx12zJJhg+44Ih0mxcaeStbLBHlT9NRoWaosYmNo
QcWfxfJsHLYeeR8ub42r44k2RlvZ+CKsE48NbDSr3tILlr+E6/RPb6OusrHP
yGutpzUbSXP2+9+W98WpBL16hUE2NCY3fur7yob39JzlgfKR+H6l9e2HtjZk
pOtEHb3bhiNHH74YGHyCpIuP3gR0d4Bpv0xjDB2QnPQ+brDoBfrCV16NK/4J
vs+ObanfOrHsIK/n051c/Bu+VpsS0I0+WW5EH7pw5ftmRP9+AwWpzM5+q15s
dHpr8aikG3NzZVuEhT9AsamtPkiyHy1FQgUeC3rxul2vomprMQb8P04Ze8dB
tMRm8VOX+1DskLDgKKcEWXzxrxW7eDiyI+qJbno/hlS2yTw/V4qcXvc17vEU
GPoRt0syOZgylj5jwbIymDeoulRfGkCUuqHP+BMuNk5avDbJrEDuXHnphIkB
eMnYJjvZ8VDhq/H9y6oq6DCYkSsuDaJrbvf+0SkUFof1j6XyqvHVyDhPrXUQ
Aa9WDuT7UCg8fSP15a9qsG5Ese+zB0FbXimn50vhpPqsowWj1Tg7ksb81zaI
CSVZVpkfhXimdn7FlBoceVW+4lPnICReBSjTAyjMU7jtSsnVwPHH09O6fYOI
UH3+80sIhZlpK35poAZpntulpg4Noqr67Q/tWAqiJTacD6E1+GV7y+ehOB8/
jw+Jm7yg0D/S2lK3vhZzVfI9Nqnyob4v33tzLYXXdqHFhhtrIRo05bbdej4W
0k5bbaVT8GLRUj5sqYVhv+ryKDU+chWrrbcyKMjlJZxL3VmLzArmDEqdj3ur
d35RZ1LY7mr+z+N4LeJpjYmhWnw8e5AwMdlAIfY3U35pQC1qSt6F39Hlw6NC
ZLF0G4Vdg5WmLq21CKXX7z9vzEfFqusSQlwKs057anV31uKR4k01ZxM+Jnq6
IlOIt1SvWXi8rxaJQ6lJzqZ8iOTt0jbkUbiUdadjx1At1gltWH7uEB+02d51
ARSFB067XeQl6QitiaObHuNjo0GyYccghWFuSWjRRjqkD2gmtpzmI9Habd5/
wxSe9BWUSYfQkZK9J/2HEx+P7Hseq/+jcP7+fmWHCDqmiWgYpjvzsUExUtKD
+Cb9jmufo+novvbGx+0CH0Uq7ikfiZclSKz1eEyH6sebRbIX+eA0llzWH6cw
eOBoaG8+HS8t3M+rufKx4twitxUTFN6Oc7r1C+nwGs9sGCIeUWDpdoy4b5qX
TtInOjSbDrXkX+GjLDg4I5D4vKnPBg99pyNwzkCOthsfUqtc01uJ0/KGTUo6
6LBe3xm61oOP0ZdlEg6TFKZb385Y3EvHkWajL13EM5WuPPQjXjtjkeg1Hh33
Y6SjEj35+JNZ55BI3MZhx2u1MTrkqiOFJW7wEb4j+l4p8XVzG6SDJ+hwemGW
8J74TPmhYRbx0U+Odj0iDOyyt6918iLxPxi6/ZN4sbNQkZ44A1vLypMUvfnY
dfX+wQHiQQqR8x5IM/C64/r0auLTi+oNR4kfKlt+4c8sBn4Le4tf9+HjoGy+
6zjxxVcKvpnJMyCWXfN41U0+9H016iaJ9yjvX5K9iIHaAmdWHfG0zL22An9Z
3e4utZQBqTUnn9zw5YP7WGTVP+Ienq50u5UM6BjGSqzw40Nx6JDiMPGdqyTW
fFrHwJeEZRJVxP9k7drNJT6DleC7SIOB7xyhx5f8+WBZNT5pI95wU63ZbTMD
h7eurZt3i4/8udLqdOKP1n/WrKMxoFGdnlRAXNe069dH4o7NR0LW65N4Vl8X
PRHAx/tFtt3PiQtt8kL3PgYOuC+Liwvkg93lYOtJXKXv+0NTawaiFD4MTwsi
degl8fkPWd+BKMs/L84w0FY1P/gBcbE/8QvogvrRGzaWdGIgTb31nWYwHzZM
oeRnxPcmKEwtdmPAZF12z4kQPoyHjh3YQ/zSAUdb1VAG9G4OXkgI48OebyDh
ROqTNj5ZeDuS5DlhOmPlXT7eaR8cXU98WlrE3K4YBraJPa/KJT6qdFl+gNR5
rEjB1/gnDIwX5kZ8Cedj9nvtIRviH1+Lr5Z4y8B9o/P7GyL5uL56/uz1fylI
KzylOjsZkPtRHlcQzUcP7/nfbaMUdA7dbO7oZeDktsDslTF8rE7OPts4QsEl
9FR5O4+BCMP+0CjihtkTjpeIM4XnPWWPknievUtxjOVj6oEc5Ydk/yZ2BZxs
kqrDxodu2yTi+SiZftCq+Tep2yyHSrpGHVpileZKPuAjK7BHu22AgkXvzoLa
zXUoidMssCGu6hlTeoh4+BLl1BpaHZrKvVZ8ID6rKr/rG+knw5E/fKt21eEl
o/vk+SQ+VEqim56R/lPoZrS1/HgdypLWby18yMdS5X2puzkk/3rr0ot96yCx
UPyT8hNSD093/pDrpnDdQyLmY2Ad4lQnJx2IyxUVxNh0Uch61eVfFFKHD3t5
YtnEZ/KWcLJ/Upi94oFlYXQdGqN4LpuT+XhhpblXr5NCk9SM+W8z6lCxesrn
LSl8WJp6iewmfdWRORiQzaiDUabtSbFnfPzrCjvGbiT77swr26SlTAhlHGXl
pPGRMC56DxUU+nSeB0iuYiIw1m8Zi3h9Z6v96nIKBvOS01xVmVh09Jz4GPFV
jmr2s8soTCmN5BlpM1HlxwjXSuejpUGkr7mUgtvSS65j+5m4fLsyM4V4heTE
5L5PZL3+no22NmNiePGj54XEh3VWai4tpqBBt3pbdYyJl7HCenXEo3Uc7g8X
kTr3NplItmGiJ6ZSbYK4iYlYZ3ghBdvWDf7G15h4djJxCTL4cBXNepz6hkLJ
61XP3nsx0TpSUb+HuNT2UAP7fApLQpaUrfBnovedjcph4obM7fOX5lFo3jpT
ejKMiT3ahgFniFv8lNkbkUtBe7bEeocoJkQrquOdif+b+eD5zhwK0f3CxnVx
TBht3bTblXjOOHfbSDaph+KxizoPmVCPiQt2J/7so9bEkywKprGD99JTyHi1
hQ6exEX+FfD2k/fvywu9eXIZTGREsFquE+eU5cqMPqcgs7utwTubiZZQTr/A
3SotTidkkHVUbPjLec1Em6b7XcE8KcoTHUgn75eRaoUj75hYzHxQJXiu0fny
+62pFFZUfcWnj0ycE/ZMEcQ5o2qap8czCv4pRafXlZJ1D1STu0D8VA8/Qu4p
BV2zrOSptUxEqj8sOk28/iDz8PYnZB+teVbqxGIiXzvhryBvBg4HRBmPKPwT
SeptbGLiiC2/yoh4drnHT8uHFPJfhq7N7mbC7fWaHRuI63sN0a4mkn03w+nV
iXEm/ORCbThkHSfsi094R1NYWL728+sVLEhqGMUrEN8/ZHTrvyAK7o+WdSut
YyElq9tjnNTbi1FRL5fbFFhuCuLB6izEh0iO/SD+sbDqBYOci8JX/LfXisbC
t3Gvkkji57MLX4WRc5S4P4chY8qC2G2djKFUPm7zd1h1XyfrpZPeaX+DhUO3
atmXyL44T3MPkLlA4d2T/rgrvizcVgjT3E688+AyX1snCj7T15j4B7LwU7XZ
TJp42glKruAc6WPVGR8fR7CgdD597NFTct541j/lhAPp26cyE1uesmB8rKzm
PdmPDQt7/960Iu81z+wjptUslHSi/Q3Z12oOJpknzSi8epNXAaV6eH02ulFB
+kxE/FnJ3ZtIf95Qkiv3qR4u5gcVrUlf3Zl2IWLKbx5aM0vu1Cg1gme57pOz
DekzsWeVz23n4a8DI26l+w/8frHkxJ+l5Fyx44CJw1kuVutOm7AtaEKF06cV
b1mD2CsjGh7rxYHBIyW77LktWFNOCsBlEKVrO8ROnerHFYVTS9qOt2K+0NVG
O9FBMLWOON5X78Majpkkay8bLQdiXOjBA0hJv3Wq4HcPZskMTC/5w8ZPXN8j
OB+Ya4kZ2Ph0Y+qHuBfK8W3gxWa/vdbBg2NBR/uZOV04q1HQIL6nHRfyfgWc
S+Rii4JcfM/VTqTvtkwqHG7Hhl81a2OMOTj+Pal5M6sdQ/3zZ3RFdeD8w/zw
73P6cWl1+m1zwza8MjEQidTvhMJhm4s1b3vhd+xmh7RaK27s8nuQ29UJ9225
ik1XenBxQ8dDEfEmKDUb1j/2+4lec/4VaZ1uvGyMmev2px7am3wj5Td0gWET
Nt9m5CfORcYnZb2rw/FFVWPC9C4cLyu9+bmmE8ddi/4LrK7FUFlwu7N3N6as
0w/8ldwBxSVDpziRVYieevKS8dIeLLULL1R43A7LiGDZWr0yzGp59WhKSQ9+
vj+a7vGuDY5b/tpxz3yGqKe36eYLvbBrkw9PbWUj8o71A/X4IgilnnzRPrMP
rmHfvKXXs5HRWnOgV+MNXGJfBM8s7oPQ6AJW7+pWaLlmLzvxNBvvVwdMlz3f
D+tArbtf9rRAh+uzI4Obgo2MuZXhzv1gaNZvWbC7BQNSIq56JSnI8nh6d/bF
foSaxZ66tLMFo1+inCZiU/Co8sv8eVf78aboxRwN3RbkRxuwWnelIMBJdO1i
H+J+Csa9G1sQkF204mBKMoxzfA6ujSK+KffNauUWaCkH6f6ye4Jubc/Y3YX9
KFX7EzRnshmjr7sjTok9gqyhyxofaQ52a+fqJZc0I0xk8SU1yzgkfZSR1Jbl
IF/2yNbx4mZ4CfvNVl8Yh/Wbn/cOzuIg46tXxrGPzSga0VobxIzFvhU9Kafl
OVD9e3N4WWEzZqx7P6ZvFIvbYieVdJdysEx9hsFEXjOyvi0xr90Sg6mfdssJ
aXNgt2bE93VGM9ZHMftsV9/H8BYloes2HFS9SbpnGEviaR45/M0oAn45hS2a
9hx8qVcdNI5phqLpzOU1shGYvfr4e64DB2tar/6wiCZx6pa3qbHCoT7/vvsJ
Zw4UzjWdDI4i86wz05+wDIfzqNTQ1mscbO9Zrb4ygswzzmv7dP0uenNHe/+G
cZAok5PkGEz+16E9LLmQUFxdE/U1J4KDRqEJje9BzdAJ+hO0VzkU05+oPz0b
xYHwWQVLTeKKrVonNr0JgUrEeesfcSROiW2Bs+80Q+j395il3cGwvNDZ8jaF
g1z/6wvkAsk8adsj7PYEoWltNd2N3JM5Y1nVKv5kvI98/APNQDzol/UU+UD6
gdnWmC6/ZrA19vpZNQXAMtVEJfgjB1FHAwzTiXuJRfmX3AxA71LW1aQvHLi5
LT6jR1wxXEL8JOMWMtrnLVn1jQMhTQOWnGC8YVlylOctOCcdK88p50C3oUeV
8iXj55fedVx+C8MLWhRKqzl4HWf4KJO40Gho8ICHP942LC49QOegb1Xbu3sC
V1mVn7jCH573Tzs31nHwwjfxkzdxi5QEuz6GH3TMHstb13Ngwu9/7SLwR7NS
6d5+mDrrZzG3kQPesNp9e+I6nvGBx1T9UFqt4nilmQPT/fXWVsS9alTlbjT7
4naI/RxhNgdi/B2K/3enDHPdIF/sM0orvN3OgYpM2zc7QTzm9bYPt/hCVoJj
N/sn6VMzZCwvCMZ/s9B/0H8TjNK1sondHLCiNXpvCOJRbBTaEn8T0X5Ob5f3
caDk9+pUhCAPgx+eXdp7E4uEf0ltoTjYOd9s4TfB/Mv0OB+zfdBeqPG6ZJCD
pthNVv2C+G+YJ9VZ+yDZw/XUvt8cxK0bj50pWC8a0/nWPB+sGR3LPj3GQX1O
VouTIP+XWVGfvb1Bvdpi3v+Xg/92Hu9PJp4kMnOq8SZvvLzoOfXyBAcFa2z7
2IJ1VJr73oPrhc2U0OEAES6Wp0/7aEPqhO3J0nlu7oWdXdP+Zf7HxYyPVxvT
bpH5X26MH7l+HeJPdidrzeBi7/tZvtMDSJwH/V+O/PJExek7+4pncvF1U8uS
s8SFbryarengCZNm6Yd1c7kQczLXBalPL8els+yPecCCMWfnPyUuOjMhqSyo
54euhtm73XGtWDls90YuTCVs5zeEEh++G9Zu5Qqal81muhYXBVnsbf5h5LmL
KxZ95FzGFNrT9uNbiFvfN9e6SzxTfGuL62UEvFml6azDBe092z89nDyX63WO
EXIJUVlqjVGGXCz8Xvmk8h7x09Oevqx0QVYilnae5EJei6EtnEA818jwjrQT
frn/mnb6NBd3DMYUxgS+p2uKpNF5bDz8tL/ZigthI1blUCJxmz9zB++cQ4GM
TA7Lngt6TnLkeBJxSePygZmO+OLVolvuQvLWlFeyM5n4p+eOH7edwQ9Lz1Mv
/bnkfp3Z/CGT+O6UeR/ErLEIanqqgVy4HBJJmZpF8pAmeSbbwQoWC36qZNzh
gvXmGG1fNhm/peqtZI0luuhGvOQwLl7ll7VSOcTt+IWjT05jQH+hZ0wsF1LU
vT7HN2SehWlu5+gnIba8INYrkwuD7Gf6+z4T173NTa08hN0iTtfHs7h4VmGm
xP5C3OJb16N2MwS1LrF0z+HCXO9etetX4lVWLuf/mUI2+vbKS/lcMDLMnr4s
J14yu9yTZoKF4sfy7Yq5aPHz2GxdS9x3TH/K2H5s6B+t28fkovXWhMQLNvFj
myUdivRxuTTjTXk9F86nby0OaRf0B/VX5b56yH9skbDrBxflqVemu3QK+oPU
Oqbxdmw7/tV6O5usr17f4V09xKd+1+uS1MGuyvu/NPu4UGA7U+sGiJvusaY6
NuHEi42yChMkn/n2sp1CLRDK2hUmrKWC18dGpauFeNjxVZUc2olfdSyQv6EM
abG3UjdFeAgyT7n5UJT4QLpl3i9FFB3fNr13Og8fRhrzL0sI/EWDePk8zJs+
KRovycNN3svjPVKC+W1pZz/PxoWcIpH90jzY6p/PtpAhbiHT0DhfFksk9Cdz
Z/FQ+SXvnOVsgd+78v25KNxfiY7byfEg9fVwXb8ccR3j7RLXhEC3KP0zX56H
rpoJrrs8cS/9psp/I7Q1UoGjlQt4oO/MyZNZSLwoNaTMaYDmm2c47LWIhyX+
7hvSFhEX2t89N7GT1mQp9VtdiYeR/iMnDZUEviDQyIFJ05T+PtilzINBzcEt
A8oCV/GfFlFMC3kTSsWokHPoHbtvcSoCn7HMMyGB1mV9kGu0kgez83HT964U
uJCTuKE5jTZjVv/kah7kv3JHRdYI3LHVYVMW7X4Bo+flOh6cfp6ILVon8EyT
mVbltAHbqC4bNR4sZfo4PmoCd3lmItZM2zXzSOc8DR5+3AkdMNQQ/N9v7xaI
9dKS3su3l2/kITzBMHneJoH/21Sx/hdtzP5H6/XNPMj6yklyNgvy9uXLd8O/
tLQPJ3900nj4+P5r72MQZxejsm0appxVbLivy8MGryTLgO2C56ZMWS8rDXO5
dqahPg+/h84GuewQzD+WcOTaTEids6nN2s2DVt4r/uE9gjw/mirqMh/n5zt+
8zDlYdbU4ul2h4mv2Pviz8Hl+PJ5banqYR6s+/qnuR0T1MnSQVHDVVh8gSpp
P8rDxbTEvLATxKPL3O45rUV1qUvRrlMkbzMOraixIr5UKfiB0gZsuOyWN9uB
B101llGUM/GtA65mYtoYqfJPzrjBgx6lEqx2h3gUTadK3ABefg+9m9J46Jgm
Jp1eQtzKxzro+1H8d2Wa4ennJD9nHgtv+EpclB+XV30MsfbnZna94OHgpsaf
78uJ5313pLPMkbNn82Mql4ecw843OmuJT0puavp9Al2yNSVTPvCQfS2G79jW
Aq+fGp1ymqexJ1Fo+ko6D9Wv1bMdJsn47UExDEVbyOWdCrn8lwdvOdlV89CK
osbDnJQeZzzvUYiTNqIQU3j55NrKViS9/+NQr+yFgAQ/i5Z9FOwbcpI8alsh
5FEq+vWiF6yNucsyD1LgBNwdrmERr/Gf7V7ihYXv3mXtPUzBcKHWj5B2Mr+o
4/5l9t64HWr+JciS3MOeG7gfHG2F15ubnlH5PrDfGDMo4UbhWPuS7x4z2bD4
dtesztMPS3xn75qWQu7ZxQEV9rpsKK5LWmwYcwcTWh7/sch9el5zjPIFfTJe
ZWCjnXAQGrgdtSnkXn7ON/SahwEbOhZWt/QdghB2OOfEzmxyL5zTuSae3J8s
Dsf6gBaMyVXGF/3eUTCSUg+aPErmz/F8pEGFoKkmNFGETuFWe8Avs4vE1RcH
+GrfRb7/iBW9jkLI/gy1EFc2DvjLDodeuovILadWPq6nMPfRqbPf3NhIChRi
/sm8iz3J63K3t1Bgx0tV7/Ii8RikFvKWhuPt1cpv3r0UurWum54NJn6X4u+d
E4GotZqhBzkUnqxUtikIY2OG+cxsE+MIXGiPN1WiKJw94npeOpLE3/XPNz80
AiuMHFuLflNYlZt+5n0sG1nF2bQHkpGYKsx4EjZC4WTk92PyiWx4XQuXUjKM
BPvVFgeLPxS2yyvpXX1InltmVyQcGIl3Do9VBd8Xp6zbvqTxCRvOs2X26X6N
xP3FkkOC77imq6tHaM9IPBdMUlun3cP/AMEp5ZY=
        "]]},
      Annotation[#, "Charting`Private`Tag$18792#1"]& ], 
     TagBox[
      {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[2], 
       Line3DBox[CompressedData["
1:eJwV2Xk4lF8UB3BFpQVZUkjJGklISouvSrIlVJLKnopkSSIVKlKRFqQQJUoK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        "]]},
      Annotation[#, "Charting`Private`Tag$18792#2"]& ], 
     TagBox[
      {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[2], 
       Line3DBox[CompressedData["
1:eJwt2Hk01N8bB3A7lb0kpWRpXygVUb1LElpFu2QLpVUltBIlFSoklRQp2Uu2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        "]]},
      Annotation[#, "Charting`Private`Tag$18792#3"]& ], 
     TagBox[
      {RGBColor[0.922526, 0.385626, 0.209179], AbsoluteThickness[2], 
       Line3DBox[CompressedData["
1:eJwV13k41F0UB3BJsrYokWzRq1QosrR+s0aLVJZERUpvKtQrpFKkRJIsWZOM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        "]]},
      Annotation[#, "Charting`Private`Tag$18792#4"]& ]}, {{Inset3DBox[
       GraphicsBox[GraphicsGroupBox[{
          {GrayLevel[1], AbsoluteThickness[4], Opacity[
            NCache[
             Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
           "Round"], 
           BSplineCurveBox[{
            Offset[{4., 0.}, {0., 0.}], Offset[{4., 0.}, {0., 0.}], 
             Offset[{6., 0.}, {0., 0.}], Offset[{6., 0.}, {0., 0.}], 
             Offset[{8., 0.}, {0., 0.}], Offset[{10., 0.}, {0., 0.}], 
             Offset[{12., 0.}, {0., 0.}], Offset[{12., 0.}, {0., 0.}]}]}, 
          {RGBColor[
           0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
           AbsoluteThickness[1.25], 
           BSplineCurveBox[{
            Offset[{4., 0.}, {0., 0.}], Offset[{4., 0.}, {0., 0.}], 
             Offset[{6., 0.}, {0., 0.}], Offset[{6., 0.}, {0., 0.}], 
             Offset[{8., 0.}, {0., 0.}], Offset[{10., 0.}, {0., 0.}], 
             Offset[{12., 0.}, {0., 0.}], Offset[{12., 0.}, {0., 0.}]}]}, 
          {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
            NCache[
             Rational[2, 3], 0.6666666666666666]]}], 
           PolygonBox[{
            Offset[{27.999999999999996`, 11.500000000000002`}, {0., 0.}], 
             Offset[{28., -11.499999999999998`}, {0., 0.}], 
             Offset[{12.000000000000004`, -11.500000000000002`}, {0., 0.}], 
             Offset[{11.999999999999998`, 11.499999999999998`}, {0., 
              0.}]}]}, 
          {RGBColor[
           0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
           AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
           StyleBox[
            RotationBox[
             SubscriptBox["f", "C"],
             BoxRotation->0.],
            StripOnInput->False,
            LineOpacity->1,
            FrontFaceOpacity->1,
            BackFaceOpacity->1,
            Opacity->1,
            FontOpacity->1], Offset[{20., 0.}, {0., 0.}], 
           ImageScaled[{Rational[1, 2], Rational[1, 2]}]]}],
        AspectRatio->Full,
        ImageSize->{45, 52},
        PlotRange->{{0, 1}, {-0.5, 0.5}}], {0.9999999795918367, 
       0.5205378379917911, 0.020537848195872732`}, 
       Offset[{-3.32531867424946, 0.}, {0, 0}]], Inset3DBox[
       GraphicsBox[GraphicsGroupBox[{
          {GrayLevel[1], AbsoluteThickness[4], Opacity[
            NCache[
             Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
           "Round"], 
           BSplineCurveBox[{
            Offset[{4., 0.}, {0., 0.}], Offset[{4., 0.}, {0., 0.}], 
             Offset[{6., 0.}, {0., 0.}], Offset[{6., 0.}, {0., 0.}], 
             Offset[{8., 0.}, {0., 0.}], Offset[{10., 0.}, {0., 0.}], 
             Offset[{12., 0.}, {0., 0.}], Offset[{12., 0.}, {0., 0.}]}]}, 
          {RGBColor[
           0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
           AbsoluteThickness[1.25], 
           BSplineCurveBox[{
            Offset[{4., 0.}, {0., 0.}], Offset[{4., 0.}, {0., 0.}], 
             Offset[{6., 0.}, {0., 0.}], Offset[{6., 0.}, {0., 0.}], 
             Offset[{8., 0.}, {0., 0.}], Offset[{10., 0.}, {0., 0.}], 
             Offset[{12., 0.}, {0., 0.}], Offset[{12., 0.}, {0., 0.}]}]}, 
          {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
            NCache[
             Rational[2, 3], 0.6666666666666666]]}], 
           PolygonBox[{
            Offset[{27.999999999999996`, 11.000000000000002`}, {0., 0.}], 
             Offset[{28., -10.999999999999998`}, {0., 0.}], 
             Offset[{12.000000000000004`, -11.000000000000002`}, {0., 0.}], 
             Offset[{11.999999999999998`, 10.999999999999998`}, {0., 
              0.}]}]}, 
          {RGBColor[
           0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
           AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
           StyleBox[
            RotationBox[
             SubscriptBox["f", "D"],
             BoxRotation->0.],
            StripOnInput->False,
            LineOpacity->1,
            FrontFaceOpacity->1,
            BackFaceOpacity->1,
            Opacity->1,
            FontOpacity->1], Offset[{20., 0.}, {0., 0.}], 
           ImageScaled[{Rational[1, 2], Rational[1, 2]}]]}],
        AspectRatio->Full,
        ImageSize->{45, 51},
        PlotRange->{{0, 1}, {-0.5, 0.5}}], {0.9999999795918367, 
       0.6418310438069044, 0.5050037458156968}, 
       Offset[{-3.32531867424946, 0.}, {0, 0}]], Inset3DBox[
       GraphicsBox[GraphicsGroupBox[{
          {GrayLevel[1], AbsoluteThickness[4], Opacity[
            NCache[
             Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
           "Round"], 
           BSplineCurveBox[{
            Offset[{4., 0.}, {0., 0.}], Offset[{4., 0.}, {0., 0.}], 
             Offset[{6., 0.}, {0., 0.}], Offset[{6., 0.}, {0., 0.}], 
             Offset[{8., 0.}, {0., 0.}], Offset[{10., 0.}, {0., 0.}], 
             Offset[{12., 0.}, {0., 0.}], Offset[{12., 0.}, {0., 0.}]}]}, 
          {RGBColor[
           0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
           AbsoluteThickness[1.25], 
           BSplineCurveBox[{
            Offset[{4., 0.}, {0., 0.}], Offset[{4., 0.}, {0., 0.}], 
             Offset[{6., 0.}, {0., 0.}], Offset[{6., 0.}, {0., 0.}], 
             Offset[{8., 0.}, {0., 0.}], Offset[{10., 0.}, {0., 0.}], 
             Offset[{12., 0.}, {0., 0.}], Offset[{12., 0.}, {0., 0.}]}]}, 
          {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
            NCache[
             Rational[2, 3], 0.6666666666666666]]}], 
           PolygonBox[{
            Offset[{26.999999999999996`, 11.000000000000002`}, {0., 0.}], 
             Offset[{27.000000000000004`, -10.999999999999998`}, {0., 0.}], 
             Offset[{12.000000000000004`, -11.000000000000002`}, {0., 0.}], 
             Offset[{11.999999999999996`, 10.999999999999998`}, {0., 
              0.}]}]}, 
          {RGBColor[
           0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
           AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
           StyleBox[
            RotationBox[
             SubscriptBox["f", "1"],
             BoxRotation->0.],
            StripOnInput->False,
            LineOpacity->1,
            FrontFaceOpacity->1,
            BackFaceOpacity->1,
            Opacity->1,
            FontOpacity->1], Offset[{19.5, 0.}, {0., 0.}], 
           ImageScaled[{Rational[1, 2], Rational[1, 2]}]]}],
        AspectRatio->Full,
        ImageSize->{44, 51},
        PlotRange->{{0, 1}, {-0.5, 0.5}}], {0.9999999795918367, 
       0.5811844408993477, 0.26277079700578476`}, 
       Offset[{-3.32531867424946, 0.}, {0, 0}]], Inset3DBox[
       GraphicsBox[GraphicsGroupBox[{
          {GrayLevel[1], AbsoluteThickness[4], Opacity[
            NCache[
             Rational[2, 3], 0.6666666666666666]], CapForm["Butt"], JoinForm[
           "Round"], 
           BSplineCurveBox[{
            Offset[{4., 0.}, {0., 0.}], Offset[{4., 0.}, {0., 0.}], 
             Offset[{6., 0.}, {0., 0.}], Offset[{6., 0.}, {0., 0.}], 
             Offset[{8., 0.}, {0., 0.}], Offset[{10., 0.}, {0., 0.}], 
             Offset[{12., 0.}, {0., 0.}], Offset[{12., 0.}, {0., 0.}]}]}, 
          {RGBColor[
           0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
           AbsoluteThickness[1.25], 
           BSplineCurveBox[{
            Offset[{4., 0.}, {0., 0.}], Offset[{4., 0.}, {0., 0.}], 
             Offset[{6., 0.}, {0., 0.}], Offset[{6., 0.}, {0., 0.}], 
             Offset[{8., 0.}, {0., 0.}], Offset[{10., 0.}, {0., 0.}], 
             Offset[{12., 0.}, {0., 0.}], Offset[{12., 0.}, {0., 0.}]}]}, 
          {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
            NCache[
             Rational[2, 3], 0.6666666666666666]]}], 
           PolygonBox[{
            Offset[{26.999999999999996`, 11.000000000000002`}, {0., 0.}], 
             Offset[{27.000000000000004`, -10.999999999999998`}, {0., 0.}], 
             Offset[{12.000000000000004`, -11.000000000000002`}, {0., 0.}], 
             Offset[{11.999999999999996`, 10.999999999999998`}, {0., 
              0.}]}]}, 
          {RGBColor[
           0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
           AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
           StyleBox[
            RotationBox[
             SubscriptBox["f", "2"],
             BoxRotation->0.],
            StripOnInput->False,
            LineOpacity->1,
            FrontFaceOpacity->1,
            BackFaceOpacity->1,
            Opacity->1,
            FontOpacity->1], Offset[{19.5, 0.}, {0., 0.}], 
           ImageScaled[{Rational[1, 2], Rational[1, 2]}]]}],
        AspectRatio->Full,
        ImageSize->{44, 51},
        PlotRange->{{0, 1}, {-0.5, 0.5}}], {0.9727989326093233, 
       0.59183153343421, 0.478175091304921}, 
       Offset[{-3.32531867424946, 0.}, {0, 0}]]}, {}}}, 
   Arrow3DBox[{{0.55, 0.501839653354967, 0.7131350258113994}, {0.55, 
    0.9658304960261659, 0.6908304960261659}}], 
   {PointSize[0.02], Point3DBox[{0.55, 0, 0},
     VertexColors->{
       RGBColor[1, 0, 0]}]}},
  Axes->True,
  AxesLabel->{
    FormBox[
     StyleBox["x", FontSize -> 18, StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
      SubscriptBox["y", "1"], FontSize -> 18, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
      SubscriptBox["y", "2"], FontSize -> 18, StripOnInput -> False], 
     TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  Boxed->False,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImagePadding->{{All, All}, {All, All}},
  ImageSize->{374.5690331369036, 344.5551896703566},
  ImageSizeRaw->Automatic,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}},
  PlotRange->{{Automatic, Automatic}, {Automatic, Automatic}, All},
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{2.358688214335349, -2.409423725902191, 0.2850740546158472},
  ViewVertical->{0.39031645758959654`, -0.3520356319207472, 
   0.8507196816771485}]], "Output",
 CellChangeTimes->{
  3.8733042514706078`*^9, 3.8733044424001904`*^9, {3.873304491016272*^9, 
   3.8733045154939623`*^9}, 3.8733046018188057`*^9, {3.873305061182213*^9, 
   3.873305070201405*^9}, {3.873305273106648*^9, 3.873305278318017*^9}, 
   3.873305324108214*^9, {3.873305440825903*^9, 3.873305477372995*^9}, 
   3.873305513020904*^9, {3.873305559308073*^9, 3.8733055911658077`*^9}, 
   3.873372863611219*^9, {3.87337291355086*^9, 3.873372936974606*^9}, 
   3.8733730249960747`*^9, {3.873375372282902*^9, 3.87337538099571*^9}, 
   3.873375428665166*^9, 3.8733755671101522`*^9, 3.873375636933708*^9},
 CellLabel->"Out[69]=",ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>", "ImageResolution" -> \
96.],ExpressionUUID->"a5735173-ff9e-4f9a-89e3-5a8bb513b34b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"G", ":=", "5"}]], "Input",
 CellChangeTimes->{{3.873285805900403*^9, 3.873285809136104*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"18c9de11-a64f-4bf7-ae74-eb87b0e85220"],

Cell["Player 1\[CloseCurlyQuote]s loss:", "Text",
 CellChangeTimes->{{3.873285762863041*^9, 
  3.873285791055707*^9}},ExpressionUUID->"483c93cc-b3b7-4dcf-84b1-\
2d7ad97450f6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"G", "*", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"EuclideanDistance", "[", 
        RowBox[{
         RowBox[{"ag2", "[", "x", "]"}], ",", 
         RowBox[{"fC", "[", "x", "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "+", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{"EuclideanDistance", "[", 
       RowBox[{
        RowBox[{"ag1", "[", "x", "]"}], ",", 
        RowBox[{"fD", "[", "x", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{"EuclideanDistance", "[", 
      RowBox[{
       RowBox[{"fC", "[", "x", "]"}], ",", 
       RowBox[{"fD", "[", "x", "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ")"}]}]], "Input",
 CellChangeTimes->{{3.873285799543892*^9, 3.873285869380973*^9}, {
  3.873375453229805*^9, 3.873375497158827*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"14fed54c-1a89-4ab5-abf1-cdd891f31cfb"],

Cell[BoxData["5.500740663727999`"], "Output",
 CellChangeTimes->{
  3.873285871846938*^9, 3.87328610178941*^9, {3.873375498256475*^9, 
   3.873375532919518*^9}, 3.873375573040753*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"7ad3dad3-1743-4f70-8fd0-686dce5bb183"]
}, Open  ]],

Cell["Player 2\[CloseCurlyQuote]s loss:", "Text",
 CellChangeTimes->{{3.873285880349283*^9, 
  3.873285897025382*^9}},ExpressionUUID->"5c2e14b6-54b5-447d-a059-\
6f71aff1c0cf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"G", "*", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"EuclideanDistance", "[", 
        RowBox[{
         RowBox[{"ag1", "[", "x", "]"}], ",", 
         RowBox[{"fC", "[", "x", "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "+", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{"EuclideanDistance", "[", 
       RowBox[{
        RowBox[{"ag2", "[", "x", "]"}], ",", 
        RowBox[{"fD", "[", "x", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{"EuclideanDistance", "[", 
      RowBox[{
       RowBox[{"fC", "[", "x", "]"}], ",", 
       RowBox[{"fD", "[", "x", "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ")"}]}]], "Input",
 CellChangeTimes->{{3.87328590248731*^9, 3.873285905894956*^9}, {
  3.873375913002104*^9, 3.8733759149576073`*^9}, {3.873375957653055*^9, 
  3.873375974093299*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"a0e2ee41-e4a9-4a93-a734-337df3dce691"],

Cell[BoxData["2.5990458112159414`"], "Output",
 CellChangeTimes->{3.873285907994482*^9, 3.873286104743848*^9, 
  3.873375575486985*^9, 3.873375975285399*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"48eb03eb-aa75-433a-91e0-2d721bc1575b"]
}, Open  ]]
},
WindowSize->{779.25, 683.25},
WindowMargins->{{Automatic, 107.25}, {-24.75, Automatic}},
FrontEndVersion->"12.3 for Linux x86 (64-bit) (July 9, 2021)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"8308a81e-1019-4ebd-9e6b-359514f9a005"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 6362, 161, 281, "Input",ExpressionUUID->"1d8ad072-048c-480a-a5ce-a5ffbc448f59"],
Cell[6945, 185, 62351, 1088, 361, 47247, 840, "CachedBoxData", "BoxData", "Output",ExpressionUUID->"a5735173-ff9e-4f9a-89e3-5a8bb513b34b"]
}, Open  ]],
Cell[69311, 1276, 195, 3, 29, "Input",ExpressionUUID->"18c9de11-a64f-4bf7-ae74-eb87b0e85220"],
Cell[69509, 1281, 175, 3, 35, "Text",ExpressionUUID->"483c93cc-b3b7-4dcf-84b1-2d7ad97450f6"],
Cell[CellGroupData[{
Cell[69709, 1288, 1168, 32, 73, "Input",ExpressionUUID->"14fed54c-1a89-4ab5-abf1-cdd891f31cfb"],
Cell[70880, 1322, 262, 4, 33, "Output",ExpressionUUID->"7ad3dad3-1743-4f70-8fd0-686dce5bb183"]
}, Open  ]],
Cell[71157, 1329, 175, 3, 35, "Text",ExpressionUUID->"5c2e14b6-54b5-447d-a059-6f71aff1c0cf"],
Cell[CellGroupData[{
Cell[71357, 1336, 1218, 33, 73, "Input",ExpressionUUID->"a0e2ee41-e4a9-4a93-a734-337df3dce691"],
Cell[72578, 1371, 236, 3, 56, "Output",ExpressionUUID->"48eb03eb-aa75-433a-91e0-2d721bc1575b"]
}, Open  ]]
}
]
*)

